window.bitflanFormattersComponent = function(mode = 'html') {
    return {
        editor: null,
        formatter: null,
        jsMinifyError: false,

        init() {
            this.editor = ace.edit(this.$refs.editor);
            this.editor.setOption("showPrintMargin", false)
            this.editor.setTheme("ace/theme/clouds");
            this.editor.session.setMode("ace/mode/" + mode);
        },

        formatHtml() {
            this.editor.setValue(
                html_beautify(
                    this.editor.getValue()
                )
            );
        },

        formatCss() {
            this.editor.setValue(
                css_beautify(
                    this.editor.getValue()
                )
            );
        },

        formatJs() {
            this.editor.setValue(
                js_beautify(
                    this.editor.getValue()
                )
            );
        },


        obfuscateJs() {
            this.editor.setValue(
                JavaScriptObfuscator.obfuscate(this.editor.getValue(), {
                    compact: false,
                    controlFlowFlattening: true,
                    controlFlowFlatteningThreshold: 1,
                    numbersToExpressions: true,
                    simplify: true,
                    stringArrayShuffle: true,
                    splitStrings: true,
                    stringArrayThreshold: 1
                }).getObfuscatedCode()
            );
        },

        minifyHtml() {
            let minifier = require('html-minifier').minify;

            this.editor.setValue(
                minifier(this.editor.session.getValue(), {
                    includeAutoGeneratedTags: true,
                    removeAttributeQuotes: true,
                    removeComments: true,
                    removeRedundantAttributes: true,
                    removeScriptTypeAttributes: true,
                    removeStyleLinkTypeAttributes: true,
                    sortClassName: true,
                    useShortDoctype: true,
                    collapseWhitespace: true,
                    minifyCSS: true,
                    minifyJS: true
                })
            )
        },

        minifyCss() {
            let minifier = require('html-minifier').minify;

            let minified = minifier('<style>' + this.editor.getValue() + '</style>', {
                includeAutoGeneratedTags: true,
                removeAttributeQuotes: true,
                removeComments: true,
                removeRedundantAttributes: true,
                removeScriptTypeAttributes: true,
                removeStyleLinkTypeAttributes: true,
                sortClassName: true,
                useShortDoctype: true,
                collapseWhitespace: true,
                minifyCSS: true,
                minifyJS: true
            });


            this.editor.setValue(
                minified.substring(7).slice(0, -8)
            );
        },

        minifyJs() {
            this.jsMinifyError = false;

            try {
                this.editor.setValue(
                    minify(this.editor.getValue()).code
                );
            } catch(error) {
                this.jsMinifyError = true;
            }
        },

        formatSQL() {
            this.editor.setValue(
                window.sqlFormatter.format(
                    this.editor.getValue()
                )
            );
        }
    }
};